// ----------------------------------------------------------------------------
//                                      DTT 2.1.5.2  (c)2007 FSL - FreeSoftLand
// Title: Get, set & delete cookie
//
// Date : 23/05/2007
// By   : FSL
// ----------------------------------------------------------------------------

function getCookie( name )
{
        var start = document.cookie.indexOf( name + "=" );
        var len = start + name.length + 1;
        if ( ( !start ) && ( name != document.cookie.substring( 0, name.length ) ) ) {
                return null;
        }
        if ( start == -1 ) return null;
        var end = document.cookie.indexOf( ';', len );
        if ( end == -1 ) end = document.cookie.length;
        return unescape( document.cookie.substring( len, end ) );
}

// ---------------------------------------------------- //
function setCookie( name, value, expires, path, domain, secure ) {
        var today = new Date();
        today.setTime( today.getTime() );
        if ( expires ) {
                expires = expires * 1000 * 60 * 60 * 24;
        }
        var expires_date = new Date( today.getTime() + (expires) );
        document.cookie = name+'='+escape( value ) +
                ( ( expires ) ? ';expires='+expires_date.toGMTString() : '' ) + //expires.toGMTString()
                ( ( path ) ? ';path=' + path : '' ) +
                ( ( domain ) ? ';domain=' + domain : '' ) +
                ( ( secure ) ? ';secure' : '' );
}

// ---------------------------------------------------- //
function deleteCookie( name, path, domain )
{
        if ( getCookie( name ) ) document.cookie = name + '=' +
                        ( ( path ) ? ';path=' + path : '') +
                        ( ( domain ) ? ';domain=' + domain : '' ) +
                        ';expires=Thu, 01-Jan-1970 00:00:01 GMT';
}
